## Neutral Element

A neutral element defined as `∅ (U+2205)`.




### Description

The neutral element `∅, neutralElement()` has no effect on all operations. For example:

<pre>
∅ * {A}           = {A}
∅ + {A}           = {A}
(∅,[Switzerland]) = ([Switzerland])

FILTER BY ∅   -- does not filter anything
WHERE (∅)     -- is like no where clause specified
</pre>

It might be created using the `neutralElement()` function.

This is mainly used in the reporting to define filters that have no effect.

It is defined as the Unicode character `∅ (U+2205)`.

On Windows you might try to input with the `ALT` key pressed `2205` on your keypad (it might not work)
On Linux you can input that character using : `CTRL + SHIFT + U` followed by `2205` and `ENTER`.



### Since Version

6.8


             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Sum - ∅ + {A}

</div>

<div class="ic3-mdx-example-body" style="display:none">

Evaluates the sum of the neutral element with a set

**Query**

```
SELECT
    ∅ + {[Geography].[Economy].[Switzerland]} ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Switzerland</td>
</tr>
<tr>
 <td>248</td>
</tr>
</table>



**Assertion : MDX Equals**

```
SELECT
    {[Geography].[Economy].[Switzerland]} ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Product - ∅ * {A}

</div>

<div class="ic3-mdx-example-body" style="display:none">

Evaluates the product of the neutral element with a set

**Query**

```
SELECT
    ∅ * {[Geography].[Economy].[Switzerland]} ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Switzerland</td>
</tr>
<tr>
 <td>248</td>
</tr>
</table>



**Assertion : MDX Equals**

```
SELECT
     crossjoin( ∅, {[Geography].[Economy].[Switzerland]} ) ON 0
FROM
    [Sales]
```


**Assertion : MDX Equals**

```
SELECT
    {[Geography].[Economy].[Switzerland]} ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Tuple - (∅,A)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Adding the neutral element to a tuple has no effect

**Query**

```
SELECT
    {(∅,[Geography].[Economy].[Switzerland])} ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Switzerland</td>
</tr>
<tr>
 <td>248</td>
</tr>
</table>



**Assertion : MDX Equals**

```
SELECT
    {[Geography].[Economy].[Switzerland]} ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Where clause

</div>

<div class="ic3-mdx-example-body" style="display:none">

Using the Neutral element in a where clause

**Query**

```
SELECT
    {[Geography].[Economy].[Switzerland]} ON 0
FROM
    [Sales]
WHERE ∅
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Switzerland</td>
</tr>
<tr>
 <td>248</td>
</tr>
</table>



**Assertion : MDX Equals**

```
SELECT
    {[Geography].[Economy].[Switzerland]} ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Subselect

</div>

<div class="ic3-mdx-example-body" style="display:none">

Using the Neutral element in a subselect

**Query**

```
SELECT
    {[Geography].[Economy].[Switzerland]} ON 0
FROM
  ( select ∅ on 0 from [Sales] )
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Switzerland</td>
</tr>
<tr>
 <td>248</td>
</tr>
</table>



**Assertion : MDX Equals**

```
SELECT
    {[Geography].[Economy].[Switzerland]} ON 0
FROM
    [Sales]
```


**Assertion : Cell Equals**

```
SELECT
    [Geography].[Economy].defaultMember ON 0
FROM
( select ∅ on 0, {[Geography].[Economy].[Switzerland]} ON 1 from [Sales] )
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### FilterBy

</div>

<div class="ic3-mdx-example-body" style="display:none">

Using the Neutral element in a filterBy

**Query**

```
SELECT
    {[Geography].[Economy].[Switzerland]} ON 0
FROM
  [Sales]
FILTERBY ∅
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Switzerland</td>
</tr>
<tr>
 <td>248</td>
</tr>
</table>



**Assertion : MDX Equals**

```
SELECT
    {[Geography].[Economy].[Switzerland]} ON 0
FROM
    [Sales]
```


**Assertion : MDX Equals**

```
SELECT
    ∅ * {∅ + {(∅,[Geography].[Economy].[Switzerland],∅,∅)}} ON 0
FROM
    (SELECT ∅ ON 0 FROM [Sales])
WHERE ∅
FILTERBY ∅
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Union, Intersection, Except and Distinct

</div>

<div class="ic3-mdx-example-body" style="display:none">

Using the Neutral element with Union, Intersection, Except and Distinct

**Query**

```
WITH
  MEMBER Union1 as Union( ∅, {[Geography].[Economy].[Switzerland]} ) is {[Geography].[Economy].[Switzerland]}
  MEMBER Union2 as Union( {[Geography].[Economy].[Switzerland]}, ∅ ) is {[Geography].[Economy].[Switzerland]}
  MEMBER Union3 as Union( ∅, ∅ ) is ∅
  MEMBER Intersect1 as Intersect( ∅, {[Geography].[Economy].[Switzerland]} ) is {[Geography].[Economy].[Switzerland]}
  MEMBER Intersect2 as Intersect( {[Geography].[Economy].[Switzerland]}, ∅ ) is {[Geography].[Economy].[Switzerland]}
  MEMBER Intersect3 as Intersect( ∅, ∅ ) is ∅
  MEMBER Except1 as Except( {[Geography].[Economy].[Switzerland]}, ∅ ) is {[Geography].[Economy].[Switzerland]}
  MEMBER Except2 as Except( ∅,{[Geography].[Economy].[Switzerland]} ) is ∅
  MEMBER Except3 as Except( ∅, ∅ ) is ∅
  MEMBER Distinct1 as Distinct( ∅ ) is ∅
SELECT
    {Union1,Union2,Union3,Intersect1,Intersect2,Intersect3,Except1,Except2,Except3,Distinct1} ON 0
FROM
  [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Union1</td>
  <td class="ic3-mdx-result-cell-header">Union2</td>
  <td class="ic3-mdx-result-cell-header">Union3</td>
  <td class="ic3-mdx-result-cell-header">Intersect1</td>
  <td class="ic3-mdx-result-cell-header">Intersect2</td>
  <td class="ic3-mdx-result-cell-header">Intersect3</td>
  <td class="ic3-mdx-result-cell-header">Except1</td>
  <td class="ic3-mdx-result-cell-header">Except2</td>
  <td class="ic3-mdx-result-cell-header">Except3</td>
  <td class="ic3-mdx-result-cell-header">Distinct1</td>
</tr>
<tr>
 <td>true</td>
 <td>true</td>
 <td>true</td>
 <td>true</td>
 <td>true</td>
 <td>true</td>
 <td>true</td>
 <td>true</td>
 <td>true</td>
 <td>true</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
  MEMBER Union1 as true
  MEMBER Union2 as true
  MEMBER Union3 as true
  MEMBER Intersect1 as true
  MEMBER Intersect2 as true
  MEMBER Intersect3 as true
  MEMBER Except1 as true
  MEMBER Except2 as true
  MEMBER Except3 as true
  MEMBER Distinct1 as true
SELECT
    {Union1,Union2,Union3,Intersect1,Intersect2,Intersect3,Except1,Except2,Except3,Distinct1} ON 0
FROM
  [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### isNeutral()

</div>

<div class="ic3-mdx-example-body" style="display:none">

You can test if an MDX entity is the neutral element with isNeutral function or is.

**Query**

```
WITH
  MEMBER test as isNeutral(∅)
SELECT
    test ON 0
FROM
  [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">test</td>
</tr>
<tr>
 <td>true</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
  MEMBER test as true
SELECT
    test ON 0
FROM
  [Sales]
```


**Assertion : MDX Equals**

```
WITH
  MEMBER test as ∅ is ∅
SELECT
    test ON 0
FROM
  [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### NeutralElement()

</div>

<div class="ic3-mdx-example-body" style="display:none">

You can use NeutralElement function to return the neutral element

**Query**

```
WITH
  MEMBER test as ∅ is NeutralElement()
SELECT
    test ON 0
FROM
  [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">test</td>
</tr>
<tr>
 <td>true</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
  MEMBER test as true
SELECT
    test ON 0
FROM
  [Sales]
```


**Assertion : MDX Equals**

```
WITH
  MEMBER test as ∅ is ∅
SELECT
    test ON 0
FROM
  [Sales]
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Axis

</div>

<div class="ic3-mdx-example-body" style="display:none">

Using the neutral element on axis as following is not supported yet.

**Query**

```
SELECT
    ∅ ON 0
FROM
    [Sales]
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_NEUTRAL_ELEMENT_MISMATCH](icCubeError.md#olap_neutral_element_mismatch)</td></tr><tr><td>Error Message</td><td>

the neutral element (∅) cannot be used in the context: axis</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Lambda Function

</div>

<div class="ic3-mdx-example-body" style="display:none">

Using the neutral element with a lambda function is equivalent to the empty set.

**Query**

```
SELECT
    TopCount( ∅, 3, [Measures].[Amount] ) ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
</tr>
</table>



**Assertion : MDX Equals**

```
SELECT
    TopCount( {}, 3, [Measures].[Amount] ) ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Lambda Function (2)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Using the neutral element with a lambda function is equivalent to the empty set.

**Query**

```
WITH MEMBER
    XX as Sum( ∅, [Measures].[Amount] )
SELECT
    XX ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">XX</td>
</tr>
<tr>
 <td></td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH MEMBER
    XX as Sum( {}, [Measures].[Amount] )
SELECT
    XX ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Eval Function

</div>

<div class="ic3-mdx-example-body" style="display:none">

Using the neutral element with the eval function is not supported yet.

**Query**

```
WITH MEMBER
    XX as Eval( ∅, [Measures].[Amount] )
SELECT
    XX ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">XX</td>
</tr>
<tr>
 <td>#ERROR : (OLAP_NEUTRAL_ELEMENT_MISMATCH)</td>
</tr>
</table>
<pre>Error Code    : [OLAP_NEUTRAL_ELEMENT_MISMATCH](icCubeError.md#olap_neutral_element_mismatch)<br>Error Message : the neutral element (∅) cannot be used in the context: SubCubeNeutral</pre>


 
</div>

                                                                         

### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
